/* $Id: vtlscan.c,v 1.2 1998/07/20 23:37:14 ericb Exp $ */
/* Copyright (C) 1997 - 1998, Hewlett-Packard Company, all rights reserved. */
/* Written by Keith Bayern */

/* vtlscan.c    list all vtl devices found */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "visa.h"

#define GTL printf ("got to line %ld in file %s\n", __LINE__, __FILE__);


static char *errtostring(ViStatus err)
{
static char errstr[100];

	sprintf(errstr,"%lx, ",(long)err);

	switch((long)err) {
	case VI_ERROR_SYSTEM_ERROR       :
	    strcat(errstr,"VI_ERROR_SYSTEM_ERROR");
	    break;

	case VI_ERROR_INV_OBJECT         :
	    strcat(errstr,"VI_ERROR_INV_OBJECT");
	    break;

	case VI_ERROR_INV_EXPR           :
	    strcat(errstr,"VI_ERROR_INV_EXPR");
	    break;

	case VI_ERROR_RSRC_NFOUND        :
	    strcat(errstr,"VI_ERROR_RSRC_NFOUND");
	    break;

	case VI_ERROR_INV_RSRC_NAME      :
	    strcat(errstr,"VI_ERROR_INV_RSRC_NAME");
	    break;

	case VI_ERROR_INV_ACC_MODE       :
	    strcat(errstr,"VI_ERROR_INV_ACC_MODE");
	    break;

	case VI_ERROR_TMO                :
	    strcat(errstr,"VI_ERROR_TMO");
	    break;

	case VI_ERROR_CLOSING_FAILED     :
	    strcat(errstr,"VI_ERROR_CLOSING_FAILED");
	    break;

	case VI_ERROR_NSUP_ATTR          :
	    strcat(errstr,"VI_ERROR_NSUP_ATTR");
	    break;

	case VI_ERROR_NSUP_ATTR_STATE    :
	    strcat(errstr,"VI_ERROR_NSUP_ATTR_STATE");
	    break;

	case VI_ERROR_ATTR_READONLY      :
	    strcat(errstr,"VI_ERROR_ATTR_READONLY");
	    break;

	case VI_ERROR_INV_EVENT          :
	    strcat(errstr,"VI_ERROR_INV_EVENT");
	    break;

	case VI_ERROR_INV_MECH           :
	    strcat(errstr,"VI_ERROR_INV_MECH");
	    break;

	case VI_ERROR_HNDLR_NINSTALLED   :
	    strcat(errstr,"VI_ERROR_HNDLR_NINSTALLED");
	    break;

	case VI_ERROR_INV_HNDLR_REF      :
	    strcat(errstr,"VI_ERROR_INV_HNDLR_REF");
	    break;

	case VI_ERROR_INV_CONTEXT        :
	    strcat(errstr,"VI_ERROR_INV_CONTEXT");
	    break;

	case VI_ERROR_RAW_WR_PROT_VIOL   :
	    strcat(errstr,"VI_ERROR_RAW_WR_PROT_VIOL");
	    break;

	case VI_ERROR_RAW_RD_PROT_VIOL   :
	    strcat(errstr,"VI_ERROR_RAW_RD_PROT_VIOL");
	    break;

	case VI_ERROR_OUTP_PROT_VIOL     :
	    strcat(errstr,"VI_ERROR_OUTP_PROT_VIOL");
	    break;

	case VI_ERROR_INP_PROT_VIOL      :
	    strcat(errstr,"VI_ERROR_INP_PROT_VIOL");
	    break;

	case VI_ERROR_BERR               :
	    strcat(errstr,"VI_ERROR_BERR");
	    break;

	case VI_ERROR_INV_SETUP          :
	    strcat(errstr,"VI_ERROR_INV_SETUP");
	    break;

	case VI_ERROR_ALLOC              :
	    strcat(errstr,"VI_ERROR_ALLOC");
	    break;

	case VI_ERROR_INV_MASK           :
	    strcat(errstr,"VI_ERROR_INV_MASK");
	    break;

	case VI_ERROR_IO                 :
	    strcat(errstr,"VI_ERROR_IO");
	    break;

	case VI_ERROR_INV_FMT            :
	    strcat(errstr,"VI_ERROR_INV_FMT");
	    break;

	case VI_ERROR_NSUP_FMT           :
	    strcat(errstr,"VI_ERROR_NSUP_FMT");
	    break;

	case VI_ERROR_LINE_IN_USE        :
	    strcat(errstr,"VI_ERROR_LINE_IN_USE");
	    break;

	case VI_ERROR_SRQ_NOCCURRED      :
	    strcat(errstr,"VI_ERROR_SRQ_NOCCURRED");
	    break;

	case VI_ERROR_INV_SPACE          :
	    strcat(errstr,"VI_ERROR_INV_SPACE");
	    break;

	case VI_ERROR_INV_OFFSET         :
	    strcat(errstr,"VI_ERROR_INV_OFFSET");
	    break;

	case VI_ERROR_NSUP_OFFSET        :
	    strcat(errstr,"VI_ERROR_NSUP_OFFSET");
	    break;

	case VI_ERROR_WINDOW_NMAPPED     :
	    strcat(errstr,"VI_ERROR_WINDOW_NMAPPED");
	    break;

	case VI_ERROR_NLISTENERS         :
	    strcat(errstr,"VI_ERROR_NLISTENERS");
	    break;

	case VI_ERROR_NCIC               :
	    strcat(errstr,"VI_ERROR_NCIC");
	    break;

	case VI_ERROR_NSUP_OPER          :
	    strcat(errstr,"VI_ERROR_NSUP_OPER");
	    break;

	case VI_ERROR_NSUP_WIDTH         :
	    strcat(errstr,"VI_ERROR_NSUP_WIDTH");
	    break;

	case VI_ERROR_INV_PROT           :
	    strcat(errstr,"VI_ERROR_INV_PROT");
	    break;

	case VI_ERROR_INV_SIZE           :
	    strcat(errstr,"VI_ERROR_INV_SIZE");
	    break;

	case VI_ERROR_WINDOW_MAPPED      :
	    strcat(errstr,"VI_ERROR_WINDOW_MAPPED");
	    break;

	case VI_ERROR_NIMPL_OPER         :
	    strcat(errstr,"VI_ERROR_NIMPL_OPER");
	    break;

	default:
	    strcat(errstr,"not listed, check manual");
	    break;
	}
	return errstr;
}



#define SHOW_ERROR \
    if(vierr!=VI_SUCCESS) \
    { \
    char *es;\
        es=errtostring(vierr);\
        printf("line %d, %s\n",__LINE__,es); \
    }


void main()
{
ViSession	defaultRM;	 /* default resource manager */
ViChar		buffer[VI_FIND_BUFLEN];
ViRsrc		descrip=buffer;
ViUInt32	num;
ViFindList	list;
ViStatus	vierr;
int			i;



printf("If the list of instruments does not match your hardware, then you\n");
printf("have a setup problem.  You also need to run your resource\n");
printf("manager setup program after each power up.  It may be named RESMAN\n");
printf("or SURM, consult your VXI hardware interface manufacturer documents.\n");
printf("\n");

    vierr=viOpenDefaultRM(&defaultRM);
    if(vierr!=VI_SUCCESS)
    {
	printf("FAILURE: viOpenDefaultRM returns %s\n",errtostring(vierr));
	exit(0);
    }

    printf("--- VTLSCAN ---\n");


    vierr=viFindRsrc(defaultRM,"?*INSTR",&list,&num,descrip);
    if(vierr!=VI_SUCCESS)
    {
        if(vierr==VI_ERROR_RSRC_NFOUND)
	{
	    printf("viFindRsrc() not working, be surm to run SURM at WIN95 startup.\n");
	}
	exit(0);
    }


    for(i=0;i<(long)num;i++)
    {
        printf("device %ld: %s\n",(long)i,descrip);


        vierr=viFindNext(list,descrip);
    }
    viClose(list);

    printf("--- END ---\n");
   
    viClose(defaultRM);

	printf("Done - press return to exit\n");
	getchar();
}

